<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Location extends Model 
{

    protected $table = 'locations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function customer()
    {
        return $this->belongsTo('App\Model\Customer');
    }

    public function events()
    {
        return $this->hasMany('App\Model\Event');
    }

}